-------------------------------------------------------------------------------------------
-- metamap.lua ---------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
require( "scripts/style.lua" );
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
gMetamapFlag = 0;
gCurWorld    = 0;
gIsEndless   = false;
if ( gMode == "endless" ) then 
	gIsEndless = true;
end

vNightMap = false;
metamap_image = "map/metamap";
-- if gLevel > 39 then
-- 	metamap_image = "map/metamap_night";
-- end;
for i = 41, 50 do
	vLevelStatus = GetLevelStatus(i);
	if ( vLevelStatus ~= 0 ) then
		vNightMap = true;
	end	
end
if GetNextNonPlayedLevel() >= 41 then
	vNightMap = true;
end
if vNightMap then
	metamap_image = "map/metamap_night";
end

if gLevel > 50 then
	gLevel = 50;
end

-- selected Level when changing world.
vLevelWorld_1 =  1;
vLevelWorld_2 = 11;
vLevelWorld_3 = 21;
vLevelWorld_4 = 31;
vLevelWorld_5 = 41;

function ChangeWorld(levelNumber)
	return 1;
end

function checkIfComic()

	if (gLevel == 1) then
		gComic = 1;
		gComicPage = 1;
		gComicMaxPage = 3;
		return true;
	elseif (gLevel == 11) then
		newWorld();
		gComic = 2;
		gComicPage = 1;
		gComicMaxPage = 1;
		return true;
	elseif (gLevel == 21) then
		newWorld();
		gComic = 3;
		gComicPage = 1;
		gComicMaxPage = 1;
		return true;
	elseif (gLevel == 31) then
		newWorld();
		gComic = 4;
		gComicPage = 1;
		gComicMaxPage = 1;
		return true;
	elseif (gLevel == 41) then
		newWorld();
		gComic = 5;
		gComicPage = 1;
		gComicMaxPage = 1;
		return true;
	end
	return false;
end

function processPlay()
	
	if ( gIsEndless ) then
		StopMusic();
		PJ_EndMapEndless();
		SwapToModal("scripts/loading.lua");
	else
		StopMusic();
		PJ_EndMetaMap();
		if ( checkIfComic() ) then
			SendGameMessage("mute_music");
			SwapToModal("scripts/comics.lua");
		else
			SwapToModal("scripts/loading.lua");
		end
	end
end

-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
-- gPosBtn1_x =  50; gPosBtn1_y = 80;
-- gPosBtn2_x = 200; gPosBtn2_y = 80;
-- gPosBtn3_x = 350; gPosBtn3_y = 80;
-- gPosBtn4_x = 500; gPosBtn4_y = 80;
-- gPosBtn5_x = 650; gPosBtn5_y = 80;
gPosBtn1_x = 0; gPosBtn1_y = 0;
gPosBtn2_x = 0; gPosBtn2_y = 0;
gPosBtn3_x = 0; gPosBtn3_y = 0;
gPosBtn4_x = 0; gPosBtn4_y = 0;
gPosBtn5_x = 0; gPosBtn5_y = 0;
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
SetState("StoryModeSessionTime",0);
SetState("MainMenuScreenTime",0);
SetState("ComicScreenTime",0);
if ( gIsEndless ) then
	SetState("MetaMapTime",0);
else
	SetState("MetaMapTime",1);
end
SetState("HelpScreenTime",0);
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
function GetPosX( levelBase10 )
	return 7 + (levelBase10-1)*31;
end
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
function GetPosY(levelBase10 )
	return 540;
end
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
function InitMetamap( level )
	if level <= 10 then
		SetWorld(1);
	elseif level <= 20 then
		SetWorld(2);
	elseif level <=30 then
		SetWorld(3);
	elseif level <=40 then
		SetWorld(4);
	else
		SetWorld(5);
	end
end

function getWorld( level )
	if level <= 10 then
		return 1;
	elseif level <= 20 then
		return 2;
	elseif level <= 30 then
		return 3;
	elseif level <= 40 then
		return 4;
	else
		return 5;
	end
end



-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
function SetWorld( world )
	
	if world == gCurWorld then
		return;
	end
	
	bgimage = "map/metamap" .. (world+1);
	
		
	if world == 1 then
		if ( gIsEndless == false ) then
			EnableWindow("btnswindow1",true);
			EnableWindow("btnswindow2",false);
			EnableWindow("btnswindow3",false);
			EnableWindow("btnswindow4",false);
			EnableWindow("btnswindow5",false);
		end
		EnableWindow("seleccion_1", true);
		EnableWindow("seleccion_2", false);
		EnableWindow("seleccion_3", false);
		EnableWindow("seleccion_4", false);
		EnableWindow("seleccion_5", false);
		SendMessage("hide1");
	elseif world == 2 then
		if ( gIsEndless == false ) then
			EnableWindow("btnswindow1",false);
			EnableWindow("btnswindow2",true);
			EnableWindow("btnswindow3",false);
			EnableWindow("btnswindow4",false);
			EnableWindow("btnswindow5",false);
		end
		EnableWindow("seleccion_1", false);
		EnableWindow("seleccion_2", true);
		EnableWindow("seleccion_3", false);
		EnableWindow("seleccion_4", false);
		EnableWindow("seleccion_5", false);
		SendMessage("hide2");
	elseif world == 3 then
		if ( gIsEndless == false ) then
			EnableWindow("btnswindow1",false);
			EnableWindow("btnswindow2",false);
			EnableWindow("btnswindow3",true);
			EnableWindow("btnswindow4",false);
			EnableWindow("btnswindow5",false);
		end
		EnableWindow("seleccion_1", false);
		EnableWindow("seleccion_2", false);
		EnableWindow("seleccion_3", true);
		EnableWindow("seleccion_4", false);
		EnableWindow("seleccion_5", false);
		SendMessage("hide3");
	elseif world == 4 then
		if ( gIsEndless == false ) then
			EnableWindow("btnswindow1",false);
			EnableWindow("btnswindow2",false);
			EnableWindow("btnswindow3",false);
			EnableWindow("btnswindow4",true);
			EnableWindow("btnswindow5",false);
		end
		EnableWindow("seleccion_1", false);
		EnableWindow("seleccion_2", false);
		EnableWindow("seleccion_3", false);
		EnableWindow("seleccion_4", true);
		EnableWindow("seleccion_5", false);
		SendMessage("hide4");
	elseif world == 5 then
		if ( gIsEndless == false ) then
			EnableWindow("btnswindow1",false);
			EnableWindow("btnswindow2",false);
			EnableWindow("btnswindow3",false);
			EnableWindow("btnswindow4",false);
			EnableWindow("btnswindow5",true);
		end
		EnableWindow("seleccion_1", false);
		EnableWindow("seleccion_2", false);
		EnableWindow("seleccion_3", false);
		EnableWindow("seleccion_4", false);
		EnableWindow("seleccion_5", true);
		SendMessage("hide5");
	end

	gCurWorld = world;
end
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
function GetButtonName(i)
	return "mapButton"..i;
end
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
function GetStaticName(i)
	return "mapStatic"..i;
end
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
-------------------------------------
vMetamap_World1ButtonGraphics = 
{ 
	"map/blanco",
	"map/w1_seleccion",
	"map/w1_seleccion",
	"map/w1_seleccion"
}
vMetamap_World1ButtonMask = "map/w1_mascara.png";
-------------------------------------
vMetamap_World2ButtonGraphics = 
{ 
	"map/blanco",
	"map/w2_seleccion",
	"map/w2_seleccion",
	"map/w2_seleccion"
}
vMetamap_World2ButtonMask  = "map/w2_mascara.png";
vMetamap_World2ClosedWorld = "map/w2_deshabiltado.png";
-------------------------------------
vMetamap_World3ButtonGraphics = 
{ 
	"map/blanco",
	"map/w3_seleccion",
	"map/w3_seleccion",
	"map/w3_seleccion"
}
vMetamap_World3ButtonMask  = "map/w3_mascara.png";
vMetamap_World3ClosedWorld = "map/w3_deshabilitado.png";
-------------------------------------
vMetamap_World4ButtonGraphics = 
{ 
	"map/blanco",
	"map/w4_seleccion",
	"map/w4_seleccion",
	"map/w4_seleccion"
}
vMetamap_World4ButtonMask  = "map/w4_mascara.png";
vMetamap_World4ClosedWorld = "map/w4_deshabiltado.png";
-------------------------------------
vMetamap_World5ButtonGraphics = 
{
	"map/blanco",
	"map/w5_seleccion",
	"map/w5_seleccion",
	"map/w5_seleccion"
}
vMetamap_World5ButtonMask  = "map/w5_mascara.png";
--vMetamap_World5ClosedWorld = "map/closed_world_1";
-------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------------
function WorldLevelIcons( world )
	
	LVL_NOT_WIN   = 0;
	LVL_WIN       = 1;
	LVL_WIN_EXP   = 2;
	
	graphicNoWin  = "map/notdone";
	
	graphicsWin  = {"map/done",
					"map/expertselec",
					"map/expertselec",
					"map/expertselec" };
	
	graphicsExp = { "map/expert",
					"map/expertselec",
					"map/expertselec",
					"map/expertselec" };
					
	vNextLevel  = GetNextNonPlayedLevel(); --gLevel; --next_nonplayed_level

	t = { BeginGroup() };
	
	iStart  = 1+((world-1)*10);
	iEnd	= iStart+9;
	iCount  = 0;
	
	-- Add Radio Buttons First
	for i = iStart, iEnd do
	
		iCount		 = iCount + 1;
		vLevelStatus = GetLevelStatus(i);
		vItemName    = GetButtonName(i);
		posX  		 = GetPosX(iCount);
		posY  		 = GetPosY(world);
		addTable     = false;
		
		if vLevelStatus == LVL_WIN then
			
			curGraphics = graphicsWin;
			addTable    = true;
		elseif vLevelStatus == LVL_WIN_EXP then
		
			curGraphics = graphicsExp;
			addTable    = true;
		elseif i == vNextLevel then
		
			curGraphics = graphicsWin;
			addTable    = true;
		end -- if
		
		if ( addTable ) then
			table.insert(t,
					Button{
						    name = vItemName,
						    type = kRadio,
						       x = posX,
						       y = posY,
						graphics = curGraphics,
					}
				);
		end --if
		
	end --for
	
	
	-- Add Missing Icons for levels not won yet.
	iCount  = 0;
	for i = iStart, iEnd do
	
		iCount		 = iCount + 1;
		vLevelStatus = GetLevelStatus(i);
		vItemName    = GetStaticName(i);
		posX  		 = GetPosX(iCount);
		posY  		 = GetPosY(world);
	
		if vLevelStatus == LVL_NOT_WIN then
			if i ~= vNextLevel then
				table.insert(t,
					Bitmap{
						 name = vItemName,
						image = graphicNoWin,
						    x = posX,
						    y = posY,
					}
				);
			end
		end -- if
	end --for
	
	return Group(t);
end


---------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------

bgimage = "map/metamap" .. (getWorld(GetNextNonPlayedLevel()))

MakeDialog
{
	-- Name the modal dialog
	name = "metamapimage",
	Bitmap
	{
		image	= bgimage,
		x		= kCenter,
		y		= kCenter,

		Metamap
		{
			name	= "metamap",
			w		= kMax,
			h		= kMax,
						
			Bitmap
			{
				image	= "map/base",
				x		= 0,
				y		= kMax-186,
			},
			SetStyle(MenuButtonStyle),
			Button
			{
				label	= "mainmenu",
				x		= 316, 
				y		= 510,
				command	= function()
							SwapToModal("scripts/welcome.lua");
						  end;
			},
			SetStyle(MenuButtonStyle),
			Button
			{
				label	= "play",
				x		= 333,
				y		= 537, 
				command	= function()
							processPlay();
						  end;
			},
			SetStyle(DialogBodyText),
			Text
			{
				x		= 60,
				y 		= 490,
				w		= 133,
				h		= 20,
				flags 	= kHAlignCenter + kVAlignTop,
				name  	= "label_location",
				label   = "decor_upgrades_title",
				font	= { "fonts/rollout.mvec", 18, BlackColor },
			},
			SetStyle(DialogBodyText),
			Text
			{
				x		= 52,
				y 		= 513-3,
				w		= 154,
				h		= 40,
				flags 	= kHAlignLeft + kVAlignTop,
				name  	= "label_score",
				font	= { "fonts/rollout.mvec", 18, BlackColor },
			},
			SetStyle(DialogBodyText),
			Text
			{
				x		= 223,
				y 		= 519,
				w		= 95,
				h		= 20,
				flags 	= kHAlignCenter + kVAlignCenter,
				name  	= "label_level_number",
				font	= { "fonts/rollout.mvec", 14, WhiteColor },
			},
			
			
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			SetStyle(ButtonStyle),
			Button
			{
				name 	= "btnWorld_1",
				type 	= kPush,
				x		= gPosBtn1_x,
				y		= gPosBtn1_y,
				graphics= vMetamap_World1ButtonGraphics,
				mask	= vMetamap_World1ButtonMask,
				command = function()
							SetWorld(1);
						  end,
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			--Bitmap
			--{
			--	name	= "imageworld_2",
			--	x		= gPosBtn2_x,
			--	y		= gPosBtn2_y,
			--	image	= vMetamap_World2ClosedWorld,
			--},
			Button
			{
				name 	= "btnWorld_2",
				type 	= kPush,
				x		= gPosBtn2_x,
				y		= gPosBtn2_y,
				graphics= vMetamap_World2ButtonGraphics,
				mask	= vMetamap_World2ButtonMask,
				command = function()
							SetWorld(2);
						  end,
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			--Bitmap
			--{
			--	name	= "imageworld_3",
			--	x		= gPosBtn3_x,
			--	y		= gPosBtn3_y,
			--	image	= vMetamap_World3ClosedWorld,
			--},
			Button
			{
				name 	= "btnWorld_3",
				type 	= kPush,
				x		= gPosBtn3_x,
				y		= gPosBtn3_y,
				graphics= vMetamap_World3ButtonGraphics,
				mask	= vMetamap_World3ButtonMask,
				command = function()
							SetWorld(3);
						  end,
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			Bitmap
			{
				name	= "imageworld_4",
				x		= gPosBtn4_x,
				y		= gPosBtn4_y,
				image	= vMetamap_World4ClosedWorld,
			},
			Button
			{
				name 	= "btnWorld_4",
				type 	= kPush,
				x		= gPosBtn4_x,
				y		= gPosBtn4_y,
				graphics= vMetamap_World4ButtonGraphics,
				mask	= vMetamap_World4ButtonMask,
				command = function()
							SetWorld(4);
						  end,
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			--Bitmap
			--{
			--	name	= "imageworld_5",
			--	x		= gPosBtn5_x,
			--	y		= gPosBtn5_y,
			--	image	= vMetamap_World5ClosedWorld,
			--},
			Button
			{
				name 	= "btnWorld_5",
				type 	= kPush,
				x		= gPosBtn5_x,
				y		= gPosBtn5_y,
				graphics= vMetamap_World5ButtonGraphics,
				mask	= vMetamap_World5ButtonMask,
				command = function()
							SetWorld(5);
						  end,
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			Window
			{
				name 	= "btnswindow1",
				w		= 800,
				h		= 600,
				x		= kCenter,
				y 		= kCenter,
				
				WorldLevelIcons(1),
			},
			Bitmap
			{
				name	= "seleccion_1",
				x		= gPosBtn1_x,
				y		= gPosBtn1_y,
				image	= "map/w1_seleccion",
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			Window
			{
				name 	= "btnswindow2",
				w		= 800,
				h		= 600,
				x		= kCenter,
				y 		= kCenter,
				
				WorldLevelIcons(2),
			},
			Bitmap
			{
				name	= "seleccion_2",
				x		= gPosBtn2_x,
				y		= gPosBtn2_y,
				image	= "map/w2_seleccion",
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			Window
			{
				name 	= "btnswindow3",
				w		= 800,
				h		= 600,
				x		= kCenter,
				y 		= kCenter,
				
				WorldLevelIcons(3),				
			},
			Bitmap
			{
				name	= "seleccion_3",
				x		= gPosBtn3_x,
				y		= gPosBtn3_y,
				image	= "map/w3_seleccion",
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			Window
			{
				name 	= "btnswindow4",
				w		= 800,
				h		= 600,
				x		= kCenter,
				y 		= kCenter,
				
				WorldLevelIcons(4),
			},
			Bitmap
			{
				name	= "seleccion_4",
				x		= gPosBtn4_x,
				y		= gPosBtn4_y,
				image	= "map/w4_seleccion",
			},	
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			Window
			{
				name 	= "btnswindow5",
				w		= 800,
				h		= 600,
				x		= kCenter,
				y 		= kCenter,
				
				WorldLevelIcons(5),
			},
			Bitmap
			{
				name	= "seleccion_5",
				x		= gPosBtn5_x,
				y		= gPosBtn5_y,
				image	= "map/w5_seleccion",
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
			Bitmap
			{
				image	= "map/sombra",
				x		= 0,
				y		= kMax-186,
			},
			---------------------------------------------------------------------------------------
			---------------------------------------------------------------------------------------
		},
		
	}
}

---------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------

if ( gIsEndless ) then
	EnableWindow("btnswindow1",false); EnableWindow("seleccion_1", false);
	EnableWindow("btnswindow2",false); EnableWindow("seleccion_2", false);
	EnableWindow("btnswindow3",false); EnableWindow("seleccion_3", false);
	EnableWindow("btnswindow4",false); EnableWindow("seleccion_4", false);
	EnableWindow("btnswindow5",false); EnableWindow("seleccion_5", false);
	SetWorld(1);
else
	InitMetamap( GetNextNonPlayedLevel() ); --gLevel );
end

---------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------------------